

<?php $__env->startSection('title', __('الملف الشخصي')); ?>

<?php $__env->startSection('content'); ?>
<div class="min-vh-100 bg-light">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container py-4">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <a href="<?php echo e(route('patient.dashboard')); ?>" class="text-muted me-3 text-decoration-none">
                        <svg width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </a>
                    <div>
                        <h1 class="fs-3 fw-bold text-dark mb-1"><?php echo e(__('الملف الشخصي')); ?></h1>
                        <p class="small text-muted mb-0"><?php echo e(__('إدارة معلوماتك الشخصية وإعدادات الحساب')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>

        <div class="row g-4">
            <!-- Profile Information -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="fs-5 fw-semibold mb-0"><?php echo e(__('المعلومات الشخصية')); ?></h3>
                    </div>
                    <div class="card-body">
                        <form id="profileForm" method="POST" action="<?php echo e(route('patient.profile.update')); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="name" class="form-label fw-medium"><?php echo e(__('الاسم الكامل')); ?></label>
                                    <input type="text" class="form-control" id="name" name="name" 
                                           value="<?php echo e(old('name', auth('patient')->user()->name ?? '')); ?>" required>
                                </div>
                                
                                <div class="col-md-6">
                                    <label for="date_of_birth" class="form-label fw-medium"><?php echo e(__('تاريخ الميلاد')); ?></label>
                                    <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" 
                                           value="<?php echo e(old('date_of_birth', auth('patient')->user()->date_of_birth ?? '')); ?>">
                                </div>

                                <div class="col-md-6">
                                    <label for="email" class="form-label fw-medium"><?php echo e(__('البريد الإلكتروني')); ?></label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?php echo e(old('email', auth('patient')->user()->email ?? '')); ?>">
                                    <?php if(auth('patient')->user()->email && !auth('patient')->user()->email_verified_at): ?>
                                    <div class="form-text text-warning">
                                        <svg class="me-1" width="14" height="14" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                        </svg>
                                        <?php echo e(__('البريد الإلكتروني غير مؤكد')); ?>

                                    </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-6">
                                    <label for="phone" class="form-label fw-medium"><?php echo e(__('رقم الهاتف')); ?></label>
                                    <input type="tel" class="form-control" id="phone" name="phone" 
                                           value="<?php echo e(old('phone', auth('patient')->user()->phone ?? '')); ?>">
                                    <?php if(auth('patient')->user()->phone && !auth('patient')->user()->phone_verified_at): ?>
                                    <div class="form-text text-warning">
                                        <svg class="me-1" width="14" height="14" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                        </svg>
                                        <?php echo e(__('رقم الهاتف غير مؤكد')); ?>

                                    </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-6">
                                    <label for="preferred_language" class="form-label fw-medium"><?php echo e(__('اللغة المفضلة')); ?></label>
                                    <select class="form-select" id="preferred_language" name="preferred_language">
                                        <option value="ar" <?php echo e(old('preferred_language', auth('patient')->user()->preferred_language ?? 'ar') == 'ar' ? 'selected' : ''); ?>>العربية</option>
                                        <option value="en" <?php echo e(old('preferred_language', auth('patient')->user()->preferred_language ?? 'ar') == 'en' ? 'selected' : ''); ?>>English</option>
                                        <option value="fr" <?php echo e(old('preferred_language', auth('patient')->user()->preferred_language ?? 'ar') == 'fr' ? 'selected' : ''); ?>>Français</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label for="gender" class="form-label fw-medium"><?php echo e(__('الجنس')); ?></label>
                                    <select class="form-select" id="gender" name="gender">
                                        <option value=""><?php echo e(__('لم يحدد')); ?></option>
                                        <option value="male" <?php echo e(old('gender', auth('patient')->user()->gender ?? '') == 'male' ? 'selected' : ''); ?>><?php echo e(__('ذكر')); ?></option>
                                        <option value="female" <?php echo e(old('gender', auth('patient')->user()->gender ?? '') == 'female' ? 'selected' : ''); ?>><?php echo e(__('أنثى')); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="row g-3 mt-1">
                                <div class="col-12">
                                    <label for="address" class="form-label fw-medium"><?php echo e(__('العنوان')); ?></label>
                                    <textarea class="form-control" id="address" name="address" rows="3" 
                                              placeholder="<?php echo e(__('العنوان الكامل (اختياري)')); ?>"><?php echo e(old('address', auth('patient')->user()->address ?? '')); ?></textarea>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                    <?php echo e(__('حفظ التغييرات')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Change Password -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h3 class="fs-5 fw-semibold mb-0"><?php echo e(__('تغيير كلمة المرور')); ?></h3>
                    </div>
                    <div class="card-body">
                        <form id="passwordForm">
                            <?php echo csrf_field(); ?>
                            
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <label for="current_password" class="form-label fw-medium"><?php echo e(__('كلمة المرور الحالية')); ?></label>
                                    <input type="password" class="form-control" id="current_password" name="current_password">
                                </div>
                                
                                <div class="col-md-6">
                                    <label for="new_password" class="form-label fw-medium"><?php echo e(__('كلمة المرور الجديدة')); ?></label>
                                    <input type="password" class="form-control" id="new_password" name="new_password">
                                </div>
                                
                                <div class="col-md-6">
                                    <label for="new_password_confirmation" class="form-label fw-medium"><?php echo e(__('تأكيد كلمة المرور الجديدة')); ?></label>
                                    <input type="password" class="form-control" id="new_password_confirmation" name="new_password_confirmation">
                                </div>
                            </div>

                            <div class="d-flex justify-content-end mt-4">
                                <button type="submit" class="btn btn-warning">
                                    <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v-2l-4-4a6 6 0 017.743-7.743M15 7l-6 6"></path>
                                    </svg>
                                    <?php echo e(__('تغيير كلمة المرور')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Account Summary -->
            <div class="col-lg-4">
                <!-- Account Status -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="fs-5 fw-semibold mb-0"><?php echo e(__('حالة الحساب')); ?></h3>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                <svg class="text-success" width="20" height="20" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="mb-0 fw-medium"><?php echo e(__('حساب نشط')); ?></p>
                                <small class="text-muted"><?php echo e(__('تم التحقق بنجاح')); ?></small>
                            </div>
                        </div>

                        <div class="row g-3 text-center">
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <div class="fs-4 fw-bold text-primary">0</div>
                                    <small class="text-muted"><?php echo e(__('إجمالي الخدمات')); ?></small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <div class="fs-4 fw-bold text-danger">0</div>
                                    <small class="text-muted"><?php echo e(__('أماكن مفضلة')); ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Account Actions -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h3 class="fs-5 fw-semibold mb-0"><?php echo e(__('إجراءات الحساب')); ?></h3>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="<?php echo e(route('patient.history')); ?>" class="btn btn-outline-primary btn-sm">
                                <svg class="me-2" width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <?php echo e(__('سجل الخدمات')); ?>

                            </a>
                            <a href="<?php echo e(route('patient.favorites')); ?>" class="btn btn-outline-primary btn-sm">
                                <svg class="me-2" width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                                </svg>
                                <?php echo e(__('الأماكن المفضلة')); ?>

                            </a>
                            <button class="btn btn-outline-danger btn-sm" onclick="confirmDeleteAccount()">
                                <svg class="me-2" width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                                <?php echo e(__('حذف الحساب')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('passwordForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const currentPassword = document.getElementById('current_password').value;
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = document.getElementById('new_password_confirmation').value;
    
    if (!currentPassword || !newPassword || !confirmPassword) {
        alert('<?php echo e(__("يرجى ملء جميع الحقول")); ?>');
        return;
    }
    
    if (newPassword !== confirmPassword) {
        alert('<?php echo e(__("كلمتا المرور غير متطابقتين")); ?>');
        return;
    }
    
    if (newPassword.length < 6) {
        alert('<?php echo e(__("يجب أن تحتوي كلمة المرور الجديدة على 6 أحرف على الأقل")); ?>');
        return;
    }
    
    // In real implementation, this would make an AJAX call
    alert('<?php echo e(__("تم تغيير كلمة المرور بنجاح")); ?>');
    this.reset();
});

function confirmDeleteAccount() {
    if (confirm('<?php echo e(__("هل أنت متأكد من حذف حسابك؟ هذا الإجراء لا يمكن التراجع عنه.")); ?>')) {
        if (confirm('<?php echo e(__("سيتم حذف جميع بياناتك وسجل زياراتك. هل تريد المتابعة؟")); ?>')) {
            // In real implementation, this would make a request to delete the account
            alert('<?php echo e(__("تم إرسال طلب حذف الحساب. سيتم التواصل معك خلال 24 ساعة.")); ?>');
        }
    }
}

// Form validation
document.getElementById('profileForm').addEventListener('submit', function(e) {
    const name = document.getElementById('name').value.trim();
    
    if (!name) {
        e.preventDefault();
        alert('<?php echo e(__("يرجى إدخال الاسم الكامل")); ?>');
        return;
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.patient', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/patient/profile.blade.php ENDPATH**/ ?>