<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header"><?php echo e(__('lang.users_management')); ?></div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger" role="alert">
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>

                    <a href="<?php echo e(route('roles.create_with_user')); ?>" class="btn btn-primary mb-3">
                        <?php echo e(__('lang.add_new_user')); ?>

                    </a>

                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo e(__('lang.name')); ?></th>
                                <th><?php echo e(__('lang.email')); ?></th>
                                <th><?php echo e(__('lang.role')); ?></th>
                                <th><?php echo e(__('lang.status')); ?></th>
                                <th><?php echo e(__('lang.actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($user->id); ?></td>
                                    <td><?php echo e($user->name); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->role); ?></td>
                                    <td>
                                        <?php echo e($user->is_active ? __('lang.active') : __('lang.inactive')); ?>

                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-sm btn-info">
                                            <?php echo e(__('lang.edit')); ?>

                                        </a>
                                        <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" style="display:inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo e(__('lang.confirm_delete_user')); ?>');">
                                                <?php echo e(__('lang.delete')); ?>

                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <?php echo e($users->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/users/index.blade.php ENDPATH**/ ?>